/*global define, alert*/
define([ 'underscore', 'backbone', 'orotranslation/js/translator', 'orolocale/js/formatter/address', 'orolocale/js/formatter/datetime'
    ], function (_, Backbone, __, addressFormatter, dateTimeFormatter) {
    'use strict';

    var $ = Backbone.$;

    /**
     * @export  svwdsale/js/po/view
     * @class   svwdsale.po.View
     * @extends Backbone.View
     */
    return Backbone.View.extend({
        tagName: 'div',

        attributes: {
            'class': 'list-group-item po-item'
        },

        events: {
            'click .item-edit-button': 'edit',
            'click .item-remove-button': 'close',
            'click .item-receive-button': 'receive'
        },

        initialize: function () {
            this.$el.attr('id', 'po-book-' + this.model.id);
            this.template = _.template($("#template-po-item").html());
            this.listenTo(this.model, 'destroy', this.remove);
            this.listenTo(this.model, 'change:active', this.toggleActive);
        },

        activate: function () {
            this.model.set('active', true);
        },

        toggleActive: function () {
            if (this.model.get('active')) {
                this.$el.addClass('active');
            } else {
                this.$el.removeClass('active');
            }
        },


        edit: function () {
            this.trigger('edit', this, this.model);
        },
        view: function() {
            this.trigger('view', this, this.model);
        },
        receive: function() {
            this.trigger('receive', this, this.model);
        },

        close: function () {
             if (confirm('Delete Purchase Order?')) {
                this.model.destroy({wait:true});
            } else {
                return false;
            }
            //     alert(__('Primary address can not be removed'));
            // } else {
            //     this.model.destroy({wait: true});
            // }
                
        },

        render: function () {
            var data = this.model.toJSON();
            data.formattedEta = null;
            data.formattedDelivered = null;
            data.formattedInfo = '';
            if(data.deliveryEta !== null) {
                data.formattedEta = dateTimeFormatter.formatDate(data.deliveryEta);
            }
            if(data.vendor !== null) {
                data.formattedInfo += data.vendor;
            }
            if(data.itemsCount !== null) {
                data.formattedInfo += ' - ' + data.itemsCount + ' items';
            }
            if(data.deliveredOn !== null) {
                data.formattedDelivered = dateTimeFormatter.formatDate(data.deliveredOn);
            }
            if(data.updatedAt !== null) {
                data.formattedModified = dateTimeFormatter.formatDateTime(data.updatedAt);
            } else {
                data.formattedModified = dateTimeFormatter.formatDateTime(data.createdAt);
            } 

            // data.formatted_address = addressFormatter.format({
            //     PO: data.poNumber,
            //     Vendor: data.vendor,
            //     ETA: data.deliveryEta,
            //     Items: data.itemsCount,
            //     Amount: data.orderAmount,
            //     Modified: data.updatedAt,
            // }, null, "\n");
            this.$el.append(this.template(data));
            if (this.model.get('primary')) {
                this.activate();
            }
            if (this.model.get('received')){
                this.$el.addClass('received');
            }
            console.log(data);
            return this;
        }
    });
});
