/*jslint browser:true, nomen:true*/
/*global define, alert*/
define([
    'jquery',
    'underscore',
    'oroui/js/app/views/base/view',
    'routing',
    'orolocale/js/formatter/datetime',
    'autolinker'
], function ($, _, BaseView, routing, dateTimeFormatter, autolinker) {
    'use strict';

    var NoteView;

    NoteView = BaseView.extend({
        options: {
            template: null,
            urls: {
                viewItem: null,
                updateItem: null,
                deleteItem: null
            }
        },

        attributes: {
            'class': 'list-item'
        },

        events: {
            'click .item-edit-button': 'onEdit',
            'click .item-remove-button': 'onDelete',
            'click .accordion-toggle': 'onToggle'
        },

        listen: {
            'change model': '_onModelChanged'
        },

        initialize: function (options) {
            this.options = _.defaults(options || {}, this.options);
            this.collapsed = true;

            if (this.options.template) {
                this.template = _.template($(this.options.template).html());
            }
        },

        getTemplateData: function () {
            var data = NoteView.__super__.getTemplateData.call(this);

            data.collapsed = this.collapsed;
            data.createdAt = dateTimeFormatter.formatDateTime(data.createdAt);
            data.updatedAt = data.updatedAt ? dateTimeFormatter.formatDateTime(data.updatedAt) : '';

            data.eta = data.eta ? dateTimeFormatter.formatDate(data.eta) : '';
            data.deliveredOn = data.deliveredOn ? dateTimeFormatter.formatDate(data.deliveredOn) : '';

            data.title = _.escape(data.title);
            if (data.owner_id) {
                data.owner_url = routing.generate('oro_user_view', {'id': data.owner_id});
            } else {
                data.owner_url = '';
            }
            //data.brief_message = data.message.replace(new RegExp('\r?\n', 'g'), ' ');
            //data.message = data.message.replace(new RegExp('\r?\n', 'g'), '<br />');
            //data.message = autolinker.link(data.message, {className: 'no-hash'});
            //if (data.brief_message.length > 200) {
            //    data.brief_message = data.brief_message.substr(0, 200);
            //}
            //data.brief_message = autolinker.link(data.brief_message, {className: 'no-hash'});

            return data;
        },

        onEdit: function () {
            this.model.collection.trigger('toEdit', this.model);
        },

        onDelete: function () {
            this.model.collection.trigger('toDelete', this.model);
        },

        onToggle: function (e) {
            e.preventDefault();
            this.model.collection.trigger('toView', this.model, this);
        },

        /**
         * Collapses/expands view elements
         *
         * @param {boolean=} collapse
         */
        toggle: function (collapse) {
            if (_.isUndefined(collapse)) {
                collapse = !this.isCollapsed();
            }
            this.$('.accordion-toggle').toggleClass('collapsed', collapse);
            this.$('.collapse').toggleClass('in', !collapse);
            this.$('.accordion-body .message').empty().html(this.model.get('contentHTML'));
        },

        isCollapsed: function () {
            return this.$('.accordion-toggle').hasClass('collapsed');
        },

        _onModelChanged: function () {
            this.collapsed = this.isCollapsed();
            this.render();
        }
    });

    return NoteView;
});
