<?php

namespace Oro\Bundle\SecurityBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

class PrivilegeCollectionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['privileges_config'] = $options['options']['privileges_config'];
        //TODO: Removing 'SHARE' from config. Remove this code after sharing is implemented.
        if (in_array('SHARE', $view->vars['privileges_config']['permissions'])) {
            array_pop($view->vars['privileges_config']['permissions']);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'oro_acl_collection';
    }

    /**
     * {@inheritdoc}
     */
    public function getParent()
    {
        return 'collection';
    }
}
