<?php

namespace Oro\Bundle\SearchBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Util\ClassUtils;

use Oro\Bundle\SearchBundle\Entity\Item;
use Oro\Bundle\SearchBundle\Query\Query;

/**
 * SearchIndexRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SearchIndexRepository extends EntityRepository
{
    /**
     * @var \Oro\Bundle\SearchBundle\Engine\Orm\BaseDriver
     */
    protected $driverRepo;

    /**
     * @var array
     */
    protected $drivers;

    /**
     * Search query to index
     *
     * @param Query $query
     *
     * @return array
     */
    public function search(Query $query)
    {
        return $this->getDriverRepo()->search($query);
    }

    /**
     * Get count of records without limit parameters in query
     *
     * @param Query $query
     *
     * @return integer
     */
    public function getRecordsCount(Query $query)
    {
        return $this->getDriverRepo()->getRecordsCount($query);
    }

    /**
     * Set array with additional drivers
     *
     * @param array $drivers
     */
    public function setDriversClasses($drivers)
    {
        $this->drivers = $drivers;
    }

    /**
     * Truncate all search index tables
     */
    public function truncateIndex()
    {
        $this->getDriverRepo()->truncateIndex();
    }

    /**
     * Get driver repository
     *
     * @return \Oro\Bundle\SearchBundle\Engine\Orm\BaseDriver
     */
    protected function getDriverRepo()
    {
        if (!is_object($this->driverRepo)) {
            $config = $this->getEntityManager()->getConnection()->getParams();
            $className = $this->drivers[$config['driver']];

            $this->driverRepo = new $className($config['driver']);
            $this->driverRepo->initRepo($this->_em, $this->_class);
        }

        return $this->driverRepo;
    }

    /**
     * Returns array of search items in following format:
     * array(
     *      '<entityClass>' => array(
     *          <entityIdentifier> => <instance of OroSearchBundle:Item>,
     *          ...
     *      ),
     *      ...
     * )
     *
     * @param array $entities
     * @return array
     */
    public function getItemsForEntities(array $entities)
    {
        if (!$entities) {
            return array();
        }

        $entityManager = $this->getEntityManager();

        $identifiers = array();
        foreach ($entities as $entity) {
            $class = ClassUtils::getClass($entity);
            $ids   = $entityManager->getClassMetadata($class)->getIdentifierValues($entity);

            if (!empty($ids)) {
                $identifiers[$class][] = current($ids);
            }
        }

        if (!$identifiers) {
            return array();
        }

        $queryBuilder = $this->createQueryBuilder('item');
        $parameterCounter = 0;

        foreach ($identifiers as $class => $entityIds) {
            $parameterName = 'class_' . $parameterCounter;
            $parameterCounter++;

            $entityCondition = 'item.entity = :' . $parameterName . ' AND ' .
                $queryBuilder->expr()->in('item.recordId', $entityIds);
            $queryBuilder->orWhere($entityCondition)
                ->setParameter($parameterName, $class);
        }

        /** @var Item[] $items */
        $items = $queryBuilder->getQuery()->getResult();

        $groupedItems = array();
        foreach ($items as $item) {
            $class = $item->getEntity();
            $id    = $item->getRecordId();
            $groupedItems[$class][$id] = $item;
        }

        return $groupedItems;
    }
}
