/*
  backgrid
  http://github.com/wyuenho/backgrid

  Copyright (c) 2013 Jimmy Yuen Ho Wong and contributors
  Licensed under the MIT @license.
*/
(function(e,t,i,n){"use strict";function r(e){return String.fromCharCode(e.charCodeAt(0)-32)+e.slice(1)}function o(e,t,i){var n=t-(e+"").length;n=0>n?0:n;for(var r="",o=0;n>o;o++)r+=i;return r+e}var s="	\n\f\r   ᠎             　\u2028\u2029﻿";if(!String.prototype.trim||s.trim()){s="["+s+"]";var l=new RegExp("^"+s+s+"*"),a=new RegExp(s+s+"*$");String.prototype.trim=function(){if(void 0===this||null===this)throw new TypeError("can't convert "+this+" to object");return String(this).replace(l,"").replace(a,"")}}var h=e.Backgrid={VERSION:"0.2.6",Extension:{},requireOptions:function(e,t){for(var n=0;n<t.length;n++){var r=t[n];if(i.isUndefined(e[r]))throw new TypeError("'"+r+"' is required")}},resolveNameToClass:function(e,t){if(i.isString(e)){var n=i.map(e.split("-"),function(e){return r(e)}).join("")+t,o=h[n]||h.Extension[n];if(i.isUndefined(o))throw new ReferenceError("Class '"+n+"' not found");return o}return e}};i.extend(h,n.Events);var c=h.Command=function(e){i.extend(this,{altKey:!!e.altKey,"char":e.char,charCode:e.charCode,ctrlKey:!!e.ctrlKey,key:e.key,keyCode:e.keyCode,locale:e.locale,location:e.location,metaKey:!!e.metaKey,repeat:!!e.repeat,shiftKey:!!e.shiftKey,which:e.which})};i.extend(c.prototype,{moveUp:function(){return this.keyCode==38},moveDown:function(){return this.keyCode===40},moveLeft:function(){return this.shiftKey&&this.keyCode===9},moveRight:function(){return!this.shiftKey&&this.keyCode===9},save:function(){return this.keyCode===13},cancel:function(){return this.keyCode===27},passThru:function(){return!(this.moveUp()||this.moveDown()||this.moveLeft()||this.moveRight()||this.save()||this.cancel())}});var d=h.CellFormatter=function(){};i.extend(d.prototype,{fromRaw:function(e){return e},toRaw:function(e){return e}});var u=h.NumberFormatter=function(e){if(e=e?i.clone(e):{},i.extend(this,this.defaults,e),this.decimals<0||this.decimals>20)throw new RangeError("decimals must be between 0 and 20")};u.prototype=new d,i.extend(u.prototype,{defaults:{decimals:2,decimalSeparator:".",orderSeparator:","},HUMANIZED_NUM_RE:/(\d)(?=(?:\d{3})+$)/g,fromRaw:function(e){if(i.isNull(e)||i.isUndefined(e))return"";e=e.toFixed(~~this.decimals);var t=e.split("."),n=t[0],r=t[1]?(this.decimalSeparator||".")+t[1]:"";return n.replace(this.HUMANIZED_NUM_RE,"$1"+this.orderSeparator)+r},toRaw:function(e){for(var t="",n=e.trim().split(this.orderSeparator),r=0;r<n.length;r++)t+=n[r];var o=t.split(this.decimalSeparator);t="";for(var r=0;r<o.length;r++)t=t+o[r]+".";t[t.length-1]==="."&&(t=t.slice(0,t.length-1));var s=(1*t).toFixed(~~this.decimals)*1;return i.isNumber(s)&&!i.isNaN(s)?s:void 0}});var m=h.DatetimeFormatter=function(e){if(e=e?i.clone(e):{},i.extend(this,this.defaults,e),!this.includeDate&&!this.includeTime)throw new Error("Either includeDate or includeTime must be true")};m.prototype=new d,i.extend(m.prototype,{defaults:{includeDate:!0,includeTime:!0,includeMilli:!1},DATE_RE:/^([+\-]?\d{4})-(\d{2})-(\d{2})$/,TIME_RE:/^(\d{2}):(\d{2}):(\d{2})(\.(\d{3}))?$/,ISO_SPLITTER_RE:/T|Z| +/,_convert:function(e,t){var n,r=null;if(i.isNumber(e)){var s=new Date(e);n=o(s.getUTCFullYear(),4,0)+"-"+o(s.getUTCMonth()+1,2,0)+"-"+o(s.getUTCDate(),2,0),r=o(s.getUTCHours(),2,0)+":"+o(s.getUTCMinutes(),2,0)+":"+o(s.getUTCSeconds(),2,0)}else{e=e.trim();var l=e.split(this.ISO_SPLITTER_RE)||[];n=this.DATE_RE.test(l[0])?l[0]:"",r=n&&l[1]?l[1]:this.TIME_RE.test(l[0])?l[0]:""}var a=this.DATE_RE.exec(n)||[],h=this.TIME_RE.exec(r)||[];if(t){if(this.includeDate&&i.isUndefined(a[0]))return;if(this.includeTime&&i.isUndefined(h[0]))return;if(!this.includeDate&&n)return;if(!this.includeTime&&r)return}var s=new Date(Date.UTC(a[1]*1||0,a[2]*1-1||0,a[3]*1||0,h[1]*1||null,h[2]*1||null,h[3]*1||null,h[5]*1||null)),c="";return this.includeDate&&(c=o(s.getUTCFullYear(),4,0)+"-"+o(s.getUTCMonth()+1,2,0)+"-"+o(s.getUTCDate(),2,0)),this.includeTime&&(c=c+(this.includeDate?"T":"")+o(s.getUTCHours(),2,0)+":"+o(s.getUTCMinutes(),2,0)+":"+o(s.getUTCSeconds(),2,0),this.includeMilli&&(c=c+"."+o(s.getUTCMilliseconds(),3,0))),this.includeDate&&this.includeTime&&(c+="Z"),c},fromRaw:function(e){return i.isNull(e)||i.isUndefined(e)?"":this._convert(e)},toRaw:function(e){return this._convert(e,!0)}});var p=h.StringFormatter=function(){};p.prototype=new d,i.extend(p.prototype,{fromRaw:function(e){return i.isUndefined(e)||i.isNull(e)?"":e+""}});var f=h.EmailFormatter=function(){};f.prototype=new d,i.extend(f.prototype,{toRaw:function(e){var t=e.trim().split("@");return t.length===2&&i.all(t)?e:void 0}});var v=h.SelectFormatter=function(){};v.prototype=new d,i.extend(v.prototype,{fromRaw:function(e){return i.isArray(e)?e:null!=e?[e]:[]}});var g=h.CellEditor=n.View.extend({initialize:function(e){h.requireOptions(e,["formatter","column","model"]),this.formatter=e.formatter,this.column=e.column,this.column instanceof R||(this.column=new R(this.column)),this.listenTo(this.model,"backgrid:editing",this.postRender)},postRender:function(e,t){return(null==t||t.get("name")==this.column.get("name"))&&this.$el.focus(),this}}),w=h.InputCellEditor=g.extend({tagName:"input",attributes:{type:"text"},events:{blur:"saveOrCancel",keydown:"saveOrCancel"},initialize:function(e){g.prototype.initialize.apply(this,arguments),e.placeholder&&this.$el.attr("placeholder",e.placeholder)},render:function(){return this.$el.val(this.formatter.fromRaw(this.model.get(this.column.get("name")))),this},saveOrCancel:function(e){var t=this.formatter,n=this.model,r=this.column,o=new c(e),s=e.type==="blur";if(o.moveUp()||o.moveDown()||o.moveLeft()||o.moveRight()||o.save()||s){e.preventDefault(),e.stopPropagation();var l=this.$el.val(),a=t.toRaw(l);i.isUndefined(a)?n.trigger("backgrid:error",n,r,l):(n.set(r.get("name"),a),n.trigger("backgrid:edited",n,r,o))}else o.cancel()&&(e.stopPropagation(),n.trigger("backgrid:edited",n,r,o))},postRender:function(e,t){if(null==t||t.get("name")==this.column.get("name"))if(this.$el.css("text-align")==="right"){var i=this.$el.val();this.$el.focus().val(null).val(i)}else this.$el.focus();return this}}),y=h.Cell=n.View.extend({tagName:"td",formatter:new d,editor:w,events:{click:"enterEditMode"},initialize:function(e){h.requireOptions(e,["model","column"]),this.column=e.column,this.column instanceof R||(this.column=new R(this.column)),this.formatter=h.resolveNameToClass(this.column.get("formatter")||this.formatter,"Formatter"),this.editor=h.resolveNameToClass(this.editor,"CellEditor"),this.listenTo(this.model,"change:"+this.column.get("name"),function(){this.$el.hasClass("editor")||this.render()}),this.listenTo(this.model,"backgrid:error",this.renderError)},render:function(){return this.$el.empty(),this.$el.text(this.formatter.fromRaw(this.model.get(this.column.get("name")))),this.delegateEvents(),this},enterEditMode:function(){var e=this.model,t=this.column;t.get("editable")&&(this.currentEditor=new this.editor({column:this.column,model:this.model,formatter:this.formatter}),e.trigger("backgrid:edit",e,t,this,this.currentEditor),this.undelegateEvents(),this.$el.empty(),this.$el.append(this.currentEditor.$el),this.currentEditor.render(),this.$el.addClass("editor"),e.trigger("backgrid:editing",e,t,this,this.currentEditor))},renderError:function(e,t){(null==t||t.get("name")==this.column.get("name"))&&this.$el.addClass("error")},exitEditMode:function(){this.$el.removeClass("error"),this.currentEditor.remove(),this.stopListening(this.currentEditor),delete this.currentEditor,this.$el.removeClass("editor"),this.render()},remove:function(){return this.currentEditor&&(this.currentEditor.remove.apply(this,arguments),delete this.currentEditor),n.View.prototype.remove.apply(this,arguments)}}),C=h.StringCell=y.extend({className:"string-cell",formatter:new p});h.UriCell=y.extend({className:"uri-cell",render:function(){this.$el.empty();var e=this.formatter.fromRaw(this.model.get(this.column.get("name")));return this.$el.append(t("<a>",{tabIndex:-1,href:e,title:e,target:"_blank"}).text(e)),this.delegateEvents(),this}}),h.EmailCell=C.extend({className:"email-cell",formatter:new f,render:function(){this.$el.empty();var e=this.formatter.fromRaw(this.model.get(this.column.get("name")));return this.$el.append(t("<a>",{tabIndex:-1,href:"mailto:"+e,title:e}).text(e)),this.delegateEvents(),this}});var b=h.NumberCell=y.extend({className:"number-cell",decimals:u.prototype.defaults.decimals,decimalSeparator:u.prototype.defaults.decimalSeparator,orderSeparator:u.prototype.defaults.orderSeparator,formatter:u,initialize:function(){y.prototype.initialize.apply(this,arguments),this.formatter=new this.formatter({decimals:this.decimals,decimalSeparator:this.decimalSeparator,orderSeparator:this.orderSeparator})}});h.IntegerCell=b.extend({className:"integer-cell",decimals:0});var x=h.DatetimeCell=y.extend({className:"datetime-cell",includeDate:m.prototype.defaults.includeDate,includeTime:m.prototype.defaults.includeTime,includeMilli:m.prototype.defaults.includeMilli,formatter:m,initialize:function(){y.prototype.initialize.apply(this,arguments),this.formatter=new this.formatter({includeDate:this.includeDate,includeTime:this.includeTime,includeMilli:this.includeMilli});var e=this.includeDate?"YYYY-MM-DD":"";e+=this.includeDate&&this.includeTime?"T":"",e+=this.includeTime?"HH:mm:ss":"",e+=this.includeTime&&this.includeMilli?".SSS":"",this.editor=this.editor.extend({attributes:i.extend({},this.editor.prototype.attributes,this.editor.attributes,{placeholder:e})})}});h.DateCell=x.extend({className:"date-cell",includeTime:!1}),h.TimeCell=x.extend({className:"time-cell",includeDate:!1});var E=h.BooleanCellEditor=g.extend({tagName:"input",attributes:{tabIndex:-1,type:"checkbox"},events:{mousedown:function(){this.mouseDown=!0},blur:"enterOrExitEditMode",mouseup:function(){this.mouseDown=!1},change:"saveOrCancel",keydown:"saveOrCancel"},render:function(){var e=this.formatter.fromRaw(this.model.get(this.column.get("name")));return this.$el.prop("checked",e),this},enterOrExitEditMode:function(e){if(!this.mouseDown){var t=this.model;t.trigger("backgrid:edited",t,this.column,new c(e))}},saveOrCancel:function(e){var t=this.model,i=this.column,n=this.formatter,r=new c(e);if(r.passThru()&&e.type!="change")return!0;r.cancel()&&(e.stopPropagation(),t.trigger("backgrid:edited",t,i,r));var o=this.$el;if(r.save()||r.moveLeft()||r.moveRight()||r.moveUp()||r.moveDown()){e.preventDefault(),e.stopPropagation();var s=n.toRaw(o.prop("checked"));t.set(i.get("name"),s),t.trigger("backgrid:edited",t,i,r)}else if(e.type=="change"){var s=n.toRaw(o.prop("checked"));t.set(i.get("name"),s),o.focus()}}});h.BooleanCell=y.extend({className:"boolean-cell",editor:E,events:{click:"enterEditMode"},render:function(){return this.$el.empty(),this.$el.append(t("<input>",{tabIndex:-1,type:"checkbox",checked:this.formatter.fromRaw(this.model.get(this.column.get("name")))})),this.delegateEvents(),this}});var T=h.SelectCellEditor=g.extend({tagName:"select",events:{change:"save",blur:"close",keydown:"close"},template:i.template('<option value="<%- value %>" <%= selected ? \'selected="selected"\' : "" %>><%- text %></option>'),setOptionValues:function(e){this.optionValues=e},setMultiple:function(e){this.multiple=e,this.$el.prop("multiple",e)},_renderOptions:function(e,t){for(var i="",n=0;n<e.length;n++)i+=this.template({text:e[n][0],value:e[n][1],selected:t.indexOf(e[n][1])>-1});return i},render:function(){this.$el.empty();var e=i.result(this,"optionValues"),n=this.formatter.fromRaw(this.model.get(this.column.get("name")));if(!i.isArray(e))throw TypeError("optionValues must be an array");for(var r=null,o=null,r=null,s=null,l=null,a=0;a<e.length;a++){var r=e[a];if(i.isArray(r))o=r[0],r=r[1],this.$el.append(this.template({text:o,value:r,selected:n.indexOf(r)>-1}));else{if(!i.isObject(r))throw TypeError("optionValues elements must be a name-value pair or an object hash of { name: 'optgroup label', value: [option name-value pairs] }");s=r.name,l=t("<optgroup></optgroup>",{label:s}),l.append(this._renderOptions(r.values,n)),this.$el.append(l)}}return this.delegateEvents(),this},save:function(e){var t=this.model,i=this.column;t.set(i.get("name"),this.formatter.toRaw(this.$el.val())),t.trigger("backgrid:edited",t,i,new c(e))},close:function(e){var t=this.model,i=this.column,n=new c(e);n.cancel()?(e.stopPropagation(),t.trigger("backgrid:edited",t,i,new c(e))):(n.save()||n.moveLeft()||n.moveRight()||n.moveUp()||n.moveDown()||e.type=="blur")&&(e.preventDefault(),e.stopPropagation(),e.type=="blur"&&this.$el.find("option").length===1&&t.set(i.get("name"),this.formatter.toRaw(this.$el.val())),t.trigger("backgrid:edited",t,i,new c(e)))}});h.SelectCell=y.extend({className:"select-cell",editor:T,multiple:!1,formatter:new v,optionValues:void 0,delimiter:", ",initialize:function(){y.prototype.initialize.apply(this,arguments),h.requireOptions(this,["optionValues"]),this.listenTo(this.model,"backgrid:edit",function(e,t,i,n){t.get("name")==this.column.get("name")&&(n.setOptionValues(this.optionValues),n.setMultiple(this.multiple))})},render:function(){this.$el.empty();var e=this.optionValues,t=this.formatter.fromRaw(this.model.get(this.column.get("name"))),n=[];try{if(!i.isArray(e)||i.isEmpty(e))throw new TypeError;for(var r=0;r<t.length;r++)for(var o=t[r],s=0;s<e.length;s++){var l=e[s];if(i.isArray(l)){var a=l[0],l=l[1];l==o&&n.push(a)}else{if(!i.isObject(l))throw new TypeError;for(var h=l.values,c=0;c<h.length;c++){var d=h[c];d[1]==o&&n.push(d[0])}}}this.$el.append(n.join(this.delimiter))}catch(u){if(u instanceof TypeError)throw TypeError("'optionValues' must be of type {Array.<Array>|Array.<{name: string, values: Array.<Array>}>}");throw u}return this.delegateEvents(),this}});var R=h.Column=n.Model.extend({defaults:{name:void 0,label:void 0,sortable:!0,editable:!0,renderable:!0,formatter:void 0,cell:void 0,headerCell:void 0},initialize:function(e){h.requireOptions(e,["cell","name"]),this.has("label")||this.set({label:this.get("name")},{silent:!0});var t=h.resolveNameToClass(this.get("headerCell"),"HeaderCell"),i=h.resolveNameToClass(this.get("cell"),"Cell");this.set({cell:i,headerCell:t},{silent:!0})}}),$=h.Columns=n.Collection.extend({model:R}),k=h.Row=n.View.extend({tagName:"tr",requiredOptions:["columns","model"],initialize:function(e){h.requireOptions(e,this.requiredOptions);var t=this.columns=e.columns;t instanceof n.Collection||(t=this.columns=new $(t));for(var i=this.cells=[],r=0;r<t.length;r++)i.push(this.makeCell(t.at(r),e));this.listenTo(t,"change:renderable",function(e,t){for(var n=0;n<i.length;n++){var r=i[n];r.column.get("name")==e.get("name")&&(t?r.$el.show():r.$el.hide())}}),this.listenTo(t,"add",function(t,n){var r=n.indexOf(t),o=this.makeCell(t,e);i.splice(r,0,o),o.column.get("renderable")||o.$el.hide();var s=this.$el;0===r?s.prepend(o.render().$el):r===n.length-1?s.append(o.render().$el):s.children().eq(r).before(o.render().$el)}),this.listenTo(t,"remove",function(e,t,n){i[n.index].remove(),i.splice(n.index,1)})},makeCell:function(e){return new(e.get("cell"))({column:e,model:this.model})},render:function(){this.$el.empty();for(var e=document.createDocumentFragment(),t=0;t<this.cells.length;t++){var i=this.cells[t];e.appendChild(i.render().el),i.column.get("renderable")||i.$el.hide()}return this.el.appendChild(e),this.delegateEvents(),this},remove:function(){for(var e=0;e<this.cells.length;e++){var t=this.cells[e];t.remove.apply(t,arguments)}return n.View.prototype.remove.apply(this,arguments)}}),D=h.EmptyRow=n.View.extend({tagName:"tr",emptyText:null,initialize:function(e){h.requireOptions(e,["emptyText","columns"]),this.emptyText=e.emptyText,this.columns=e.columns},render:function(){this.$el.empty();var e=document.createElement("td");return e.setAttribute("colspan",this.columns.length),e.textContent=this.emptyText,this.el.setAttribute("class","empty"),this.el.appendChild(e),this}}),N=h.HeaderCell=n.View.extend({tagName:"th",events:{"click a":"onClick"},_direction:null,initialize:function(e){h.requireOptions(e,["column","collection"]),this.column=e.column,this.column instanceof R||(this.column=new R(this.column)),this.listenTo(this.collection,"backgrid:sort",this._resetCellDirection)},direction:function(e){return arguments.length&&(this._direction&&this.$el.removeClass(this._direction),e&&this.$el.addClass(e),this._direction=e),this._direction},_resetCellDirection:function(e,t,i,n){n==this.collection&&(e!==this.column.get("name")?this.direction(null):this.direction(t))},onClick:function(e){e.preventDefault();var t=this.column.get("name");this.column.get("sortable")&&(this.direction()==="ascending"?this.sort(t,"descending",function(e,i){var n=e.get(t),r=i.get(t);return n===r?0:n>r?-1:1}):this.direction()==="descending"?this.sort(t,null):this.sort(t,"ascending",function(e,i){var n=e.get(t),r=i.get(t);return n===r?0:r>n?-1:1}))},sort:function(e,t,i){i=i||this._cidComparator;var r=this.collection;if(n.PageableCollection&&r instanceof n.PageableCollection){var o;o="ascending"===t?-1:"descending"===t?1:null,r.setSorting(o?e:null,o),r.mode=="client"?(r.fullCollection.comparator||(r.fullCollection.comparator=i),r.fullCollection.sort()):r.fetch({reset:!0})}else r.comparator=i,r.sort();this.collection.trigger("backgrid:sort",e,t,i,this.collection)},_cidComparator:function(e,t){var n=e.cid,r=t.cid;if(!i.isUndefined(n)&&!i.isUndefined(r)){if(n=n.slice(1)*1,r=r.slice(1)*1,r>n)return-1;if(n>r)return 1}return 0},render:function(){this.$el.empty();var e=t("<a>").text(this.column.get("label")).append("<b class='sort-caret'></b>");return this.$el.append(e),this.delegateEvents(),this}});h.HeaderRow=h.Row.extend({requiredOptions:["columns","collection"],initialize:function(){h.Row.prototype.initialize.apply(this,arguments)},makeCell:function(e,t){var i=e.get("headerCell")||t.headerCell||N;return i=new i({column:e,collection:this.collection})}});var M=h.Header=n.View.extend({tagName:"thead",initialize:function(e){h.requireOptions(e,["columns","collection"]),this.columns=e.columns,this.columns instanceof n.Collection||(this.columns=new $(this.columns)),this.row=new h.HeaderRow({columns:this.columns,collection:this.collection})},render:function(){return this.$el.append(this.row.render().$el),this.delegateEvents(),this},remove:function(){return this.row.remove.apply(this.row,arguments),n.View.prototype.remove.apply(this,arguments)}}),O=h.Body=n.View.extend({tagName:"tbody",initialize:function(e){h.requireOptions(e,["columns","collection"]),this.columns=e.columns,this.columns instanceof n.Collection||(this.columns=new $(this.columns)),this.row=e.row||k,this.rows=this.collection.map(function(e){var t=new this.row({columns:this.columns,model:e});return t},this),this.emptyText=e.emptyText,this._unshiftEmptyRowMayBe();var t=this.collection;this.listenTo(t,"add",this.insertRow),this.listenTo(t,"remove",this.removeRow),this.listenTo(t,"sort",this.refresh),this.listenTo(t,"reset",this.refresh),this.listenTo(t,"backgrid:edited",this.moveToNextCell)},_unshiftEmptyRowMayBe:function(){this.rows.length===0&&this.emptyText!=null&&this.rows.unshift(new D({emptyText:this.emptyText,columns:this.columns}))},insertRow:function(e,t,r){if(this.rows[0]instanceof D&&this.rows.pop().remove(),!(t instanceof n.Collection||r))return this.collection.add(e,r=t),void 0;r=i.extend({render:!0},r||{});var o=new this.row({columns:this.columns,model:e}),s=t.indexOf(e);this.rows.splice(s,0,o);var l=this.$el,a=l.children(),h=o.render().$el;r.render&&(s>=a.length?l.append(h):a.eq(s).before(h))},removeRow:function(e,t,n){return n?((i.isUndefined(n.render)||n.render)&&this.rows[n.index].remove(),this.rows.splice(n.index,1),this._unshiftEmptyRowMayBe(),void 0):(this.collection.remove(e,n=t),this._unshiftEmptyRowMayBe(),void 0)},refresh:function(){for(var e=0;e<this.rows.length;e++)this.rows[e].remove();return this.rows=this.collection.map(function(e){var t=new this.row({columns:this.columns,model:e});return t},this),this._unshiftEmptyRowMayBe(),this.render(),this.collection.trigger("backgrid:refresh",this),this},render:function(){this.$el.empty();for(var e=document.createDocumentFragment(),t=0;t<this.rows.length;t++){var i=this.rows[t];e.appendChild(i.render().el)}return this.el.appendChild(e),this.delegateEvents(),this},remove:function(){for(var e=0;e<this.rows.length;e++){var t=this.rows[e];t.remove.apply(t,arguments)}return n.View.prototype.remove.apply(this,arguments)},moveToNextCell:function(e,t,i){var n=this.collection.indexOf(e),r=this.columns.indexOf(t);if(i.moveUp()||i.moveDown()||i.moveLeft()||i.moveRight()||i.save()){var o=this.columns.length,s=o*this.collection.length;if(i.moveUp()||i.moveDown()){var l=this.rows[n+(i.moveUp()?-1:1)];l&&l.cells[r].enterEditMode()}else if(i.moveLeft()||i.moveRight())for(var a=i.moveRight(),h=n*o+r+(a?1:-1);h>=0&&s>h;a?h++:h--){var c=~~(h/o),d=h-c*o,u=this.rows[c].cells[d];if(u.column.get("renderable")&&u.column.get("editable")){u.enterEditMode();break}}}this.rows[n].cells[r].exitEditMode()}});h.Footer=n.View.extend({tagName:"tfoot",initialize:function(e){h.requireOptions(e,["columns","collection"]),this.columns=e.columns,this.columns instanceof n.Collection||(this.columns=new h.Columns(this.columns))}}),h.Grid=n.View.extend({tagName:"table",className:"backgrid",header:M,body:O,footer:null,initialize:function(e){h.requireOptions(e,["columns","collection"]),e.columns instanceof n.Collection||(e.columns=new $(e.columns)),this.columns=e.columns;var t=i.omit(e,["el","id","attributes","className","tagName","events"]);this.header=e.header||this.header,this.header=new this.header(t),this.body=e.body||this.body,this.body=new this.body(t),this.footer=e.footer||this.footer,this.footer&&(this.footer=new this.footer(t)),this.listenTo(this.columns,"reset",function(){this.header=new(this.header.remove().constructor)(t),this.body=new(this.body.remove().constructor)(t),this.footer&&(this.footer=new(this.footer.remove().constructor)(t)),this.render()})},insertRow:function(e,t,i){return this.body.insertRow(e,t,i)},removeRow:function(e,t,i){return this.body.removeRow(e,t,i)},insertColumn:function(e,t){return t=t||{render:!0},this.columns.add(e,t),this},removeColumn:function(e,t){return this.columns.remove(e,t),this},render:function(){return this.$el.empty(),this.$el.append(this.header.render().$el),this.footer&&this.$el.append(this.footer.render().$el),this.$el.append(this.body.render().$el),this.delegateEvents(),this.trigger("backgrid:rendered",this),this},remove:function(){return this.header.remove.apply(this.header,arguments),this.body.remove.apply(this.body,arguments),this.footer&&this.footer.remove.apply(this.footer,arguments),n.View.prototype.remove.apply(this,arguments)}})})(this,jQuery,_,Backbone);