<?php

namespace Oro\Bundle\ChartBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ChartSettingsCollectionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        foreach ($options['chart_configs'] as $chartName => $chartConfig) {
            $builder->add(
                $chartName,
                'oro_chart_setting',
                [
                    'chart_name'   => $chartName,
                    'chart_config' => $chartConfig
                ]
            );
        }
    }

    /**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setRequired(['chart_configs']);

        $resolver->setAllowedTypes(
            [
                'chart_configs' => 'array'
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'oro_chart_settings_collection';
    }
}
