<?php

namespace Oro\Bundle\CalendarBundle\Tests\Functional;

use Oro\Bundle\CalendarBundle\Entity\CalendarEvent;
use Oro\Bundle\CalendarBundle\Tests\Functional\DataFixtures\LoadCalendarEventData;
use Oro\Bundle\TestFrameworkBundle\Test\WebTestCase;

/**
 * @outputBuffering enabled
 * @dbIsolation
 */
class AjaxCalendarEventControllerTest extends WebTestCase
{
    /** @var CalendarEvent $calendarEvent */
    protected $calendarEvent;

    protected function setUp()
    {
        $this->initClient([], $this->generateBasicAuthHeader());
        $this->loadFixtures(['Oro\Bundle\CalendarBundle\Tests\Functional\DataFixtures\LoadCalendarEventData']);
        $this->calendarEvent = $this->getCalendarEventByTitle(LoadCalendarEventData::CALENDAR_EVENT_TITLE);
    }

    public function testChangeInvitationStatus()
    {
        $availableStatuses = [
            CalendarEvent::ACCEPTED,
            CalendarEvent::TENTATIVELY_ACCEPTED,
            CalendarEvent::DECLINED
        ];

        foreach ($availableStatuses as $status) {
            $calendarEventId = $this->calendarEvent->getId();
            $this->client->request(
                'GET',
                $this->getUrl(
                    'oro_calendar_event_'.$status,
                    ['id' => $calendarEventId, 'status' => $status]
                )
            );
            $response = $this->client->getResponse();
            $data = json_decode($response->getContent(), true);
            $this->assertTrue($data['successful']);
            $calendarEvent = $this->getCalendarEventByTitle(LoadCalendarEventData::CALENDAR_EVENT_TITLE);
            $this->assertEquals($status, $calendarEvent->getInvitationStatus());
        }
    }

    /**
     * @param string $title
     * @return CalendarEvent
     */
    protected function getCalendarEventByTitle($title)
    {
        return $this->getContainer()->get('doctrine')
            ->getRepository('OroCalendarBundle:CalendarEvent')
            ->findOneBy(['title' => $title]);
    }
}
