<?php

namespace SoundView\Bundle\WarehouseBundle\Form\Type;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections\Collection;

use Symfony\Component\Routing\Router;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

use Oro\Bundle\LocaleBundle\Formatter\NameFormatter;
use Oro\Bundle\SecurityBundle\SecurityFacade;

/**
 * Description of InventoryType
 *
 * @author Brandon
 */
class InventoryType extends AbstractType
{
     /**
     * @var Router
     */
    protected $router;

    /**
     * @var NameFormatter
     */
    protected $nameFormatter;

    /**
     * @var SecurityFacade
     */
    protected $securityFacade;

     /**
     * @param Router $router
     * @param NameFormatter $nameFormatter
     * @param SecurityFacade $securityFacade
     */
    public function __construct(Router $router, NameFormatter $nameFormatter, SecurityFacade $securityFacade)
    {
        $this->nameFormatter  = $nameFormatter;
        $this->router         = $router;
        $this->securityFacade = $securityFacade;

    }
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'location',
                'entity',
                [
                    'required' => false,
                    'label' => 'Location',
                    'class' => 'SoundView\Bundle\WarehouseBundle\Entity\InventoryLocation',
                    'empty_value' => 'Select Location...',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('location')->orderBy('location.name');
                    }
                ]
            )
            ->add(
                    'purchaseOrder',
                    'svwd_purchase_order_select',
                    [
                        'required' => true,
                        'label' => 'Purchase Order'
                    ]
            )
            ->add(
                'itemCounts',
                'svwd_item_count_collection',
                array(
                    'label'    => 'Items',
                    'type'     => 'svwd_item_count',
                    'required' => false,
                    'options'  => array('data_class' => 'SoundView\Bundle\SaleBundle\Entity\OrderItemCount')
                )
            )
            ->add(
                    'description',
                    'textarea',
                    [
                        'required' => false,
                        'label' => 'Description'
                    ]
            );

    }





    /**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => 'SoundView\Bundle\WarehouseBundle\Entity\Inventory',
                'intention' => 'inventory',
                'cascade_validation' => true,
		'csrf_protection' => false
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_inventory';
    }
    //put your code here
}