<?php

namespace SoundView\Bundle\WarehouseBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Component\HttpFoundation\JsonResponse;

use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\UserBundle\Entity\User;
use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;

use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;


use SoundView\Bundle\WarehouseBundle\Entity\Inventory;
use SoundView\Bundle\WarehouseBundle\Entity\InventoryLocation;

/**
 * Description of InventoryController
 *
 * @author Brandon
 */
class InventoryController extends Controller {

    /**
     * @Route(
     *      ".{_format}",
     *      name="svwd_inventory_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     * @Acl(
     *      id="svwd_inventory_view",
     *      type="entity",
     *      class="SvwdWarehouseBundle:Inventory",
     *      permission="VIEW"
     * )
     * @Template
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('svwd_warehouse.inventory.class')
        ];
    }
    
    /**
     * @Route("/view/{id}", name="svwd_inventory_view", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="svwd_inventory_view",
     *      type="entity",
     *      permission="VIEW",
     *      class="SvwdWarehouseBundle:Inventory"
     * )
     */
    public function viewAction(Inventory $entity)
    {
        return [
            'entity' => $entity
        ];
    }

	/**
	 * @Route("/ajax/activate/{id}",
	 *      name="svwd_inventory_activate",
	 *      requirements={"id"="\d+"})
	 * @param Inventory $entity
	 * @param string $status
	 * @return JsonResponse
	 */
	public function activateAction(Inventory $entity)
	{
		$em = $this->getDoctrine()->getManager();
		$active = $entity->getActive() ? false : true;
		$entity->setActive($active);
		$em->flush($entity);

		//$this->get('oro_calendar.send_processor.email')->sendRespondNotification($entity);

		return new JsonResponse(['successful' => true]);
	}
    
    /**
     * @Route("/widget/po-inventory/{id}", name="svwd_inventory_widget_po_inventory", requirements={"id"="\d+"})
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function poInventoryAction(PurchaseOrder $entity)
    {
        return array('entity' => $entity);
    }
    
    /**
     * @Route("/pdf/{id}", name="svwd_inventory_print_pdf", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function pdfAction(Inventory $entity)
    {
        $html = $this->renderView('SvwdWarehouseBundle:Inventory:label.html.twig', array(
            'entity'  => $entity
        ));
        
        $dompdf = $this->get('slik_dompdf');
        
        $paper_size = array(0,0,396,306);
        
        $dompdf->set_paper('Letter');
        
    
        // Generate the pdf
        //$dompdf->($html);
        
        

        return new Response(
            //$this->get('knp_snappy.pdf')->getOutputFromHtml($html, array('dpi'=> 300, 'page'=>'landscape')),
            $dompdf->renderPdf($html),
            200,
            [
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename="INVENTORY-'.$entity->getPurchaseOrder()->getPoNumber().'.pdf"'
            ]
        );
    }
    
    /**
     * @Route("/create", name="svwd_inventory_create")
     * @Acl(
     *      id="svwd_inventory_create",
     *      type="entity",
     *      class="SvwdWarehouseBundle:Inventory",
     *      permission="CREATE"
     * )
     * @Template("SvwdWarehouseBundle:Inventory:update.html.twig")
     */
    public function createAction()
    {
        $entity = new Inventory();

        
        $orderId = $this->getRequest()->get('orderId');
        if ($orderId) {
            $order = $this->getRepository('SoundViewSaleBundle:PurchaseOrder')->find($orderId);
            if (!$order) {
                throw new NotFoundHttpException(sprintf('Purchase Order with ID %s is not found', $orderId));
            }
            $entity->setPurchaseOrder($order);
        }


        return $this->update($entity);
    }
    
    /**
     * @Route("/update/{id}", name="svwd_inventory_update", requirements={"id"="\d+"})
     * @Template
     * @Acl(
     *      id="svwd_inventory_update",
     *      type="entity",
     *      class="SvwdWarehouseBundle:Inventory",
     *      permission="EDIT"
     * )
     */
    public function updateAction(Inventory $inventory)
    {
        return $this->update($inventory);
    }
    
    protected function update(Inventory $entity = null)
    {
        if (!$entity) {
            $entity = $this->getManager()->createEntity();
        }
        return $this->get('oro_form.model.update_handler')->handleUpdate(
            $entity,
            $this->get('svwd_warehouse.inventory.form'),
            function (Inventory $entity) {
                return array(
                    'route' => 'svwd_inventory_update',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            function (Inventory $entity) {
                return array(
                    'route' => 'svwd_inventory_view',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            'Inventory Saved',
            $this->get('svwd_warehouse.inventory.form.handler')
        );
    }

    /**
     * @return \Oro\Bundle\SoapBundle\Entity\Manager\ApiEntityManager
     */
    protected function getManager()
    {
        return $this->container->get('svwd_warehouse.inventory.manager.api');
    }
    
    /**
     * @param string $entityName
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    protected function getRepository($entityName)
    {
        return $this->getDoctrine()->getRepository($entityName);
    }

}