<?php

namespace SoundView\Bundle\SaleBundle\PDF;

use Slik\DompdfBundle\DomPDF;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

require_once dirname(__FILE__).'/../../../../../vendor/slik/dompdf-bundle/Slik/DompdfBundle/DomPDF/dompdf_config.inc.php';

/**
 * A wrapper class for DOMPDF to render pdfs from Symfony2
 *
 * @author Brandon Schneider <brandon@soundviewseattle.com>
 */
class PDFGenerator extends Controller
{
	public $container;

	public $pdf;

	public $template;

	public $html;

	public function __construct()
	{
		$this->pdf = new \DomPDF();
	}


	public function writeHtml($data)
	{
		$this->html .= $this->renderView($this->template, $data); 
	}

	public function renderPdf()
	{
		$this->pdf->set_paper(DOMPDF_DEFAULT_PAPER_SIZE);
		$this->pdf->load_html($this->html);
		$this->pdf->render();
	}

	public function setTemplate($template)
	{
		$this->template = $template;
	}

	/**
	 * Stream the pdf document
	 * @param  string $docname The name of the document
	 */
	public function streamPdf($docname)
	{
		$this->pdf->stream($docname);
	}

	/**
	 * get the raw pdf output
	 */
	public function output()
	{
		return $this->pdf->output();
	}


}