<?php

namespace SoundView\Bundle\SaleBundle\Migrations\Data\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;

use Doctrine\Common\DataFixtures\AbstractFixture;

use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\PropertyAccess\PropertyAccess;

use Oro\Bundle\ActivityListBundle\Provider\ActivityListChainProvider;
use Oro\Bundle\OrganizationBundle\Entity\Organization;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\SecurityBundle\Authentication\Token\UsernamePasswordOrganizationToken;
use Oro\Bundle\BatchBundle\ORM\Query\BufferedQueryResultIterator;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;



class UpdatePurchaseOrderReceived extends AbstractFixture implements ContainerAwareInterface
{
    const BATCH_SIZE = 300;

    const ENTITY_CLASS = 'SoundViewSaleBundle:PurchaseOrder';

    /** @var ContainerInterface */
    protected $container;


    /**
     * {@inheritdoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $this->addReceivedData($manager, SELF::ENTITY_CLASS);
    }

    public function addReceivedData(
        ObjectManager $manager,
        $entityClass
    ) {
        if ($this->container->hasParameter('installed') && $this->container->getParameter('installed')) {
            $queryBuilder = $manager->getRepository($entityClass)->createQueryBuilder('entity');
            $iterator     = new BufferedQueryResultIterator($queryBuilder);
            $iterator->setBufferSize(self::BATCH_SIZE);

            $count = 0;
            $entities   = [];

            foreach ($iterator as $entity) {
                $entities[] = $entity;
                $count++;

                if (0 == $count % self::BATCH_SIZE) {
                    $this->saveReceivedData($manager, $entities);
                    $entities = [];
                }
            }

            if ($count % static::BATCH_SIZE > 0) {
                $this->saveReceivedData($manager, $entities);
            }
        }
    }

    /**
     * @param ObjectManager             $manager
     * @param PurchaseOrder[]           $entities
     */
    protected function saveReceivedData(
        ObjectManager $manager,
        $entities
    ) {
        foreach ($entities as $entity) {
			if(!$entity->isReceived()) {
				$entity->setReceived(false);
				$manager->persist($entity);
			}
        }
        $manager->flush();
    }


    /**
     * @param User         $user
     * @param Organization $organization
     */
    protected function setSecurityContext(User $user, Organization $organization)
    {
        $securityContext = $this->container->get('security.context');
        $token           = new UsernamePasswordOrganizationToken($user, $user->getUsername(), 'main', $organization);
        $securityContext->setToken($token);
    }
}
