<?php

namespace SoundView\Bundle\SaleBundle\Migrations\Data\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\Persistence\ObjectManager;

use SoundView\Bundle\SaleBundle\Entity\PurchaseOrderStatus;

class LoadPurchaseOrderStatusData extends AbstractFixture
{
    /**
     * @var array
     */
    protected $data = array(
        'created'    => 'Created',
        'acknowledged'      => 'Acknowledged',
        'received' => 'Received',
        'inventoried'   => 'Inventoried',
        'completed' => 'Completed'
    );

    /**
     * @param \Doctrine\Common\Persistence\ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        $i = 0;
        foreach ($this->data as $sourceName => $sourceLabel) {
            $i += 1;
            $source = new PurchaseOrderStatus($sourceName);
            $source->setLabel($sourceLabel);
            $source->setOrder($i);
            $manager->persist($source);
        }

        $manager->flush();
    }
}
