<?php

namespace SoundView\Bundle\SaleBundle\Form\Type;

use Doctrine\ORM\EntityRepository;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PurchaseOrderType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', 'hidden')
			->add('received', 'checkbox', [ 'required' => false ])
            ->add(
                'poNumber',
                'text',
                array(
                    'label' => 'PO#',
                    'required' => true
                )
            )
			->add(
				'vendor',
				'entity',
				[
                    'label' => 'Vendor',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\Vendor',
                    'required' => true,
					'empty_value' => 'Select Vendor',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('vendor')->orderBy('vendor.name');
                    }
                ]
			)	
            ->add(
                'deliveryEta',
                'oro_datetime',
                array(
                    'label' => 'ETA',
                    'required' => false
                )
            )
			->add(
                'deliveredOn',
                'oro_datetime',
                array(
                    'label' => 'Delivered On',
                    'required' => false
                )
            )
            ->add(
                'itemCounts',
                'svwd_item_count_collection',
                array(
                    'label'    => 'Items',
                    'type'     => 'svwd_item_count',
                    'required' => false,
                    'options'  => array('data_class' => 'SoundView\Bundle\SaleBundle\Entity\OrderItemCount')
                )
            )
			->add(
				'orderAmount',
				'oro_money',
				[
					'label' => 'Order Amount',
					'required' => false,
				]
			)
			->add(
				'description',
				'textarea',
				[
					'label' => 'Description',
					'required' => false
				]
			);
    }
	
	/**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            array(
                'data_class' => 'SoundView\Bundle\SaleBundle\Entity\PurchaseOrder',
                'intention'  => 'svwd_sale_po',
                'extra_fields_message' => 'This form should not contain extra fields: "{{ extra_fields }}"'
            )
        );
    }


    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_purchase_order';
    }
}
