<?php

namespace SoundView\Bundle\SaleBundle\Form\Type;

use Doctrine\ORM\EntityRepository;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PaymentType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', 'hidden')
            ->add(
                'invoiceNumber',
                'text',
                array(
                    'label' => 'Invoice #',
                    'required' => true
                )
            )
			->add(
				'paymentType',
				'entity',
				[
                    'label' => 'Type',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\PaymentType',
                    'required' => true,
					'empty_value' => 'Select Type',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('type')->orderBy('type.order');
                    }
                ]
			)
			->add(
				'paymentMethod',
				'entity',
				[
                    'label' => 'Method',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\PaymentMethod',
                    'required' => true,
					'empty_value' => 'Select Method',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('method')->orderBy('method.order');
                    }
                ]
			)		
            ->add(
                'paymentDate',
                'oro_datetime',
                array(
                    'label' => 'Date',
                    'required' => false
                )
            )
			->add(
				'amount',
				'oro_money',
				[
					'label' => 'Payment Amount',
					'required' => false,
				]
			)
			->add(
				'description',
				'textarea',
				[
					'label' => 'Description',
					'required' => false
				]
			);
    }
	
	/**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            array(
                'data_class' => 'SoundView\Bundle\SaleBundle\Entity\Payment',
                'intention'  => 'payment',
                'extra_fields_message' => 'This form should not contain extra fields: "{{ extra_fields }}"'
            )
        );
    }


    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_payment';
    }
}
