<?php

namespace SoundView\Bundle\SaleBundle\EventListener;

use Doctrine\ORM\UnitOfWork;
use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;

use Oro\Bundle\UserBundle\Entity\User;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\CommissionBundle\Entity\Commission;
use SoundView\Bundle\CommissionBundle\Entity\CommissionType;
use SoundView\Bundle\CommissionBundle\Entity\CommissionStatus;

class SaleListener
{
    /**
     * @var ClassMetadata
     */
    protected $commissionMetaData;

    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var SecurityContextInterface
     */
    protected $securityContext;

    protected $firstHalf;
	protected $secondHalf;
	protected $pending;

    /**
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // can't inject security context directly because of circular dependency for Doctrine entity manager
        $this->container = $container;
    }
    /**
     * @param LifecycleEventArgs $args
     */
    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if (!$this->isSaleEntity($entity)) {
            return;
        }


        /** @var Contact $entity */
        $this->setCreatedProperties($entity, $args->getEntityManager());
        $this->setUpdatedProperties($entity, $args->getEntityManager());
    }


    /**
     * @param PreUpdateEventArgs $args
     */
    public function preUpdate(PreUpdateEventArgs $args)
    {
        $entity = $args->getEntity();
        if (!$this->isSaleEntity($entity)) {
            return;
        }


        /** @var Sale $entity */
        $this->setUpdatedProperties($entity, $args->getEntityManager(), true);
    }



    /**
     * @param object $entity
     * @return bool
     */
    protected function isSaleEntity($entity)
    {
        return $entity instanceof Sale;
    }

    /**
     * @param Sale $sale
     * @param EntityManager $entityManager
     */
    protected function setCreatedProperties(Sale $sale, EntityManager $entityManager)
    {
        $sale->setCreatedAt(new \DateTime('now', new \DateTimeZone('UTC')));
        $sale->setCreatedBy($this->getUser($entityManager));
    }

    /**
     * @param Sale $sale
     * @param EntityManager $entityManager
     * @param bool $update
     */
    protected function setUpdatedProperties(Sale $sale, EntityManager $entityManager, $update = false)
    {
        $newUpdatedAt = new \DateTime('now', new \DateTimeZone('UTC'));
        $newUpdatedBy = $this->getUser($entityManager);

        $unitOfWork = $entityManager->getUnitOfWork();
        if ($update) {
            $unitOfWork->propertyChanged($sale, 'updatedAt', $sale->getUpdatedAt(), $newUpdatedAt);
            $unitOfWork->propertyChanged($sale, 'updatedBy', $sale->getUpdatedBy(), $newUpdatedBy);
        }

        $sale->setUpdatedAt($newUpdatedAt);
        $sale->setUpdatedBy($newUpdatedBy);
    }


	
	

    /**
     * @param LifecycleEventArgs $args
     */
    public function onFlush(OnFlushEventArgs $args)
    {
		   
		$em = $args->getEntityManager();
		
		$typeRepo = $em->getRepository('SvwdCommissionBundle:CommissionType');
		$statusRepo = $em->getRepository('SvwdCommissionBundle:CommissionStatus');
		
		$firstHalf = $typeRepo->findOneByName('first');
		$secondHalf = $typeRepo->findOneByName('second');
		$pending = $statusRepo->findOneByName('pending');
		
        $uow = $em->getUnitOfWork();

        // we would like to listen on insertions and updates events
        $entities = $uow->getScheduledEntityInsertions();

        $updateEntities = $uow->getScheduledEntityUpdates();
        

        foreach ($uow->getScheduledEntityInsertions() as $entity) {
            // every time we update or insert a new ContactEmail entity we do the work
            if ($entity instanceof Sale) {
				$this->createCommission($entity, $em);
				$this->createCommission($entity, $em, true);
            }

        }

        foreach ($updateEntities as $entity) {
            // every time we update or insert a new ContactEmail entity we do the work
            if ($entity instanceof Sale && $entity->getCommissions()->count() == 0 ) {

                $this->createCommission($entity, $em);
                $this->createCommission($entity, $em, true);

            } 
                //elseif ($entity instanceof Sale){
			// 	if($entity->isFirstHalfReady()) {
			// 		$commission = $entity->getFirstHalfCommission();
			// 		if(!$commission->isPaid() && !$commission->isDue()) {
			// 			$commission->setDue(1);
			// 			$em->persist($commission);
			// 			$uow->computeChangeSet($this->getCommissionMetaData($em), $commission);
			// 		}
			// 	} 
			// 	if($entity->isSecondHalfReady()) {
			// 		$commission = $entity->getSecondHalfCommission();
			// 		if(!$commission->isPaid() && !$commission->isDue()) {
			// 			$commission->setDue(1);
			// 			$em->persist($commission);
			// 			$uow->computeChangeSet($this->getCommissionMetaData($em), $commission);
			// 		}
			// 	}
			// }

        }
    }

    protected function createCommission(Sale $sale, EntityManager $entityManager, $secondHalf = false)
    {
    	$unitOfWork = $entityManager->getUnitOfWork();
    	$commission = new Commission();

    	$typeRepo = $entityManager->getRepository('SvwdCommissionBundle:CommissionType');
		$statusRepo = $entityManager->getRepository('SvwdCommissionBundle:CommissionStatus');


		$firstHalfType = $typeRepo->findOneByName('first');
		$secondHalfType = $typeRepo->findOneByName('second');
		$type = $secondHalf ? $secondHalfType : $firstHalfType;

		$pending = $statusRepo->findOneByName('pending');

		$commission->setSale($sale);
		$commission->setOwner($sale->getOwner());
		$commission->setRelatedAccount($sale->getRelatedAccount());
		$commission->setType($type);
		$commission->setStatus($pending);
		//$commission->createRefNumber();

		$entityManager->persist($commission);

        $unitOfWork->computeChangeSet($this->getCommissionMetaData($entityManager), $commission);
				
    }
	

	
	    /**
     * @param EntityManager $entityManager
     * @return ClassMetadata
     */
    protected function getCommissionMetaData(EntityManager $entityManager)
    {
        if (!$this->commissionMetaData) {
            $this->commissionMetaData = $entityManager->getClassMetadata('SvwdCommissionBundle:Commission');
        }

        return $this->commissionMetaData;
    }
	
	protected function generateRefNumber(Sale $sale)
	{
		$i = substr($sale->getOwner()->getFirstName(), 0, 1);
		$i .= substr($sale->getOwner()->getLastName(), 0, 1);
		
		$so = $sale->getSoNumber();
		
		$ref = $i;
		$ref .= $so;
		
		return (string) trim($ref);
		
		
	}

    /**
     * @param EntityManager $entityManager
     * @return User|null
     */
    protected function getUser(EntityManager $entityManager)
    {
        $token = $this->getSecurityContext()->getToken();
        if (!$token) {
            return null;
        }

        $user = $token->getUser();
        if (!$user) {
            return null;
        }

        if ($entityManager->getUnitOfWork()->getEntityState($user) == UnitOfWork::STATE_DETACHED) {
            $user = $entityManager->find('OroUserBundle:User', $user->getId());
        }

        return $user;
    }

	 /**
     * @return SecurityContextInterface
     */
    protected function getSecurityContext()
    {
        if (!$this->securityContext) {
            $this->securityContext = $this->container->get('security.context');
        }

        return $this->securityContext;
    }


	


    
}
