<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;

use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;

use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PaymentType;
use SoundView\Bundle\SaleBundle\Entity\PaymentMethod;



 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_payment",
 * )
 * @ORM\HasLifecycleCallbacks()
 * @Config(
 *      routeName="svwd_sale_payment_index",
 *      routeView="svwd_sale_payment_view",
 *      defaultValues={
 *          "entity"={
 *              "icon"="icon-money"
 *          },
 *          "security"={
 *              "type"="ACL",
 *              "group_name"=""
 *          },
 *          "dataaudit"={
 *              "auditable"=true
 *          }
 *      }
 * )
 */
 
 
 
class Payment
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Soap\ComplexType("int", nillable=true)
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="invoice_number", type="string", length=255, nullable=false)
     * @Soap\ComplexType("string", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "identity"=true
     *          }
     *      }
     * )
     */
    protected $invoiceNumber;
	
	 /**
     * @var PaymentType
     *
     * @ORM\ManyToOne(targetEntity="PaymentType")
     * @ORM\JoinColumn(name="payment_type", referencedColumnName="name", onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $paymentType;
	
    /**
     * @var PaymentMethod
     *
     * @ORM\ManyToOne(targetEntity="PaymentMethod")
     * @ORM\JoinColumn(name="method", referencedColumnName="name", onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $paymentMethod;
	
	
	 /**
     * @var double
     *
     * @ORM\Column(name="amount", type="money", nullable=true)
     */
    protected $amount;
	
	 /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $description;
	
	/**
     * @var bool
     *
     * @ORM\Column(name="is_due", type="boolean")
     */
	protected $due = 0;
	
	/**
     * @var bool
     *
     * @ORM\Column(name="is_paid", type="boolean")
     */
	protected $paid = 0;
	
	 /**
     * @var \DateTime
     *
     * @ORM\Column(name="payment_date", type="datetime", nullable=true)
     */
    protected $paymentDate;
	
	 /**
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\SaleBundle\Entity\Sale", inversedBy="payments")
     * @ORM\JoinColumn(name="sale_id", referencedColumnName="id", onDelete="CASCADE")
     */

    protected $salesOrder;


	 /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $updatedAt;
	
	/**
     * @param string|null $poNumber
     */
    public function __construct($invoiceNumber = null)
    {
        $this->invoiceNumber = $invoiceNumber;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set invoice number
     *
     * @param string $invoiceNumber
     * @return Payment
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->invoiceNumber = $invoiceNumber;

        return $this;
    }

    /**
     * Get invoice number
     *
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
	
	/**
     * @param PaymentType $type
     */
    public function setPaymentType($type)
    {
        $this->paymentType = $type;
    }

    /**
     * @return PaymentType
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
	
     /**
     * @param PaymentMethod $method
     */
    public function setPaymentMethod($method)
    {
        $this->paymentMethod = $method;
    }

    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
	
	 /**
     * @param string $description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
	
	    /**
     * @param float $amount
     *
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
	
	public function isFirstHalf()
	{
		return $this->getPaymentType()->getName() == 'first' ? true : false;	
	}
	
	public function isFinal()
	{
		return $this->getPaymentType()->getName() == 'final' ? true : false;	
	}
	
	public function createRefNumber()
	{
		$result = 'PYMT-';
		$result .= $this->salesOrder->getSoNumber();
		$result .= strtoupper(chr(($this->salesOrder()->getPayments()->count() % 26) + 97));
		if($this->paymentType->getName() == 'adjustment') {
			$result .= '-ADJ';
		}
		
		return $result; 
			
	}
	
	
    /**
     * Set paymentDate
     *
     * @param \DateTime $paymentDate
     * @return Sale
     */
    public function setPaymentDate($paymentDate)
    {
        $this->paymentDate = $paymentDate;

        return $this;
    }

    /**
     * Get paymentDate
     *
     * @return \DateTime 
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }	
	
	
	/**
     * Set sale as owner.
     *
     * @param Sale $sale
     */
    public function setSalesOrder(Sale $salesOrder = null)
    {
        $this->salesOrder = $salesOrder;
    }

    /**
     * Get owner sale.
     *
     * @return Sale
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }
	
	
	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isDue()
    {
        return $this->isPaid() ? false : $this->due;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setDue($due)
    {
        $this->due = $due;

        return $this;
    }
	
	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isPaid()
    {
        return $this->paid;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setPaid($paid)
    {
        $this->paid = $paid;

        return $this;
    }
	
	
    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
	
	/**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }

}
