<?php
/**
 * Created by PhpStorm.
 * User: brandon
 * Date: 12/19/14
 * Time: 2:52 PM
 */

namespace SoundView\Bundle\SaleBundle\Entity;

use Doctrine\Common\Util\ClassUtils;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;

use Oro\Bundle\FormBundle\Entity\EmptyItem;

/**
 * @ORM\Entity
 * @ORM\Table("svwd_order_item_counts")
 * @Config(
 *      defaultValues={
 *          "entity"={
 *              "icon"="icon-envelope"
 *          },
 *          "note"={
 *              "immutable"=true
 *          },
 *          "activity"={
 *              "immutable"=true
 *          },
 *          "attachment"={
 *              "immutable"=true
 *          }
 *      }
 * )
 */
class OrderItemCount implements EmptyItem {
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="itemCount", type="integer", length=11, nullable=false)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "identity"=true
     *          }
     *      }
     * )
     */
    protected $itemCount;

    /**
     * @var ItemType
     *
     * @ORM\ManyToOne(targetEntity="ItemType")
     * @ORM\JoinColumn(name="item_type", referencedColumnName="name", onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $itemType;

    /**
     * @ORM\ManyToOne(targetEntity="PurchaseOrder", inversedBy="itemCounts")
     * @ORM\JoinColumn(name="purchase_order_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
     */
    protected $purchaseOrder;

    /**
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\WarehouseBundle\Entity\Inventory", inversedBy="itemCounts")
     * @ORM\JoinColumn(name="inventory_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
     */
    protected $inventory;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set email
     *
     * @param string $count
     * @return OrderItemCount
     */
    public function setItemCount($count)
    {
        $this->itemCount = $count;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getItemCount()
    {
        return $this->itemCount;
    }

    /**
     * @param ItemType $itemType
     * @return OrderItemCount
     */
    public function setItemType($itemType)
    {
        $this->itemType = $itemType;

    }

    /**
     * @return string
     */
    public function getItemType()
    {
        return $this->itemType;
    }

    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }

    public function setPurchaseOrder($purchaseOrder)
    {
        $this->purchaseOrder = $purchaseOrder;
    }

    public function getInventory()
    {
        return $this->purchaseOrder;
    }

    public function setInventory($inventory)
    {
        $this->inventory = $inventory;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        $str = $this->getItemCount();
        $str .= ' '.$this->getItemType()->getLabel();
        return (string)$str;
    }

    /**
     * Check if entity is empty.
     *
     * @return bool
     */
    public function isEmpty()
    {
        return empty($this->itemCount);
    }

    /**
     * @param mixed $other
     * @return bool
     */
    public function isEqual($other)
    {
        $class = ClassUtils::getClass($this);

        /** @var AbstractAddress $other */
        if (!$other instanceof $class) {
            return false;
        } elseif ($this->getId() && $other->getId()) {
            return $this->getId() == $other->getId();
        } elseif ($this->getId() || $other->getId()) {
            return false;
        } else {
            return $this == $other;
        }
    }


}