<?php

namespace SoundView\Bundle\SaleBundle\Datagrid\Extension;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Oro\Bundle\DataGridBundle\Extension\Formatter\Property\AbstractProperty;
use Oro\Bundle\DataGridBundle\Datasource\ResultRecordInterface;

use SoundView\Bundle\SaleBundle\Entity\OrderItemCount;

class ItemCountProperty extends AbstractProperty
{
    const ROUTE_KEY       = 'route';
    const IS_ABSOLUTE_KEY = 'isAbsolute';
    const ANCHOR_KEY      = 'anchor';
    const PARAMS_KEY      = 'params';
	const CLASS_KEY       = 'entity_class';

    /** @var array */
    protected $excludeParams = [self::ROUTE_KEY, self::IS_ABSOLUTE_KEY, self::ANCHOR_KEY, self::PARAMS_KEY];


	protected $container;

    /**
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;

    }

    /**
     * {@inheritdoc}
     */
    public function getRawValue(ResultRecordInterface $record)
    {


		$em = $this->getDoctrine()->getManager();
	    $repo = $em->getRepository($this->get(SELF::CLASS_KEY));

	    $entity = $repo->find($record->getValue('id'));
	    //$entity = $em->find($record->getValue('id'));



	    return $this->getItemCountStrings($entity);

	    //print_r($record->getValue('entity_class'));

	    //print_r($record);

	    //return $record->getValue

        //return $route . $this->getOr(self::ANCHOR_KEY);
    }

    /**
     * Get route parameters from record
     *
     * @param ResultRecordInterface $record
     *
     * @return array
     */
    protected function getParameters(ResultRecordInterface $record)
    {
        $result = [];
        foreach ($this->getOr(self::PARAMS_KEY, []) as $name => $dataKey) {
            if (is_numeric($name)) {
                $name = $dataKey;
            }
            $result[$name] = $record->getValue($dataKey);
        }

        return $result;
    }

	public function getDoctrine()
	{
		return $this->container->get('doctrine');
	}

	public function getItemCountStrings($entity)
	{
		$str = '';

		foreach($entity->getItemCounts() as $itemCount)
		{
			$str .= $this->getItemCountString($itemCount) . ' ';
		}

		return $str;
	}
	public function getItemCountString(OrderItemCount $entity)
	{
		$itemType = substr(ucfirst($entity->getItemType()->getName()), 0, 1);
		return $entity->getItemCount() . $itemType;
	}
}
