<?php

namespace SoundView\Bundle\SaleBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\UserBundle\Entity\User;
use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\SoldJob;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;




class SoldJobController extends Controller
{
    /**
     * @Route(
     *      "/soldjob.{_format}",
     *      name="svwd_sold_job_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     * @Acl(
     *      id="svwd_sold_job_view",
     *      type="entity",
     *      class="SvwdSaleBundle:SoldJob",
     *      permission="VIEW"
     * )
     * @Template
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('svwd_sale.sold_job.class')
        ];
	}
	
	 
	
}
