<?php

namespace SoundView\Bundle\SaleBundle\Controller\Api\Soap;

use Symfony\Component\Form\FormInterface;
use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;
use Oro\Bundle\SoapBundle\Entity\Manager\ApiEntityManager;
use Oro\Bundle\SoapBundle\Controller\Api\Soap\SoapController;
use Oro\Bundle\SoapBundle\Form\Handler\ApiFormHandler;

class SaleController extends SoapController
{
    /**
     * @Soap\Method("getSales")
     * @Soap\Param("page", phpType="int")
     * @Soap\Param("limit", phpType="int")
     * @Soap\Result(phpType = "SoundView\Bundle\SaleBundle\Entity\SaleSoap[]")
     * @AclAncestor("svwd_sale_view")
     */
    public function cgetAction($page = 1, $limit = 10)
    {
        return $this->handleGetListRequest($page, $limit);
    }

    /**
     * @Soap\Method("getSale")
     * @Soap\Param("id", phpType = "int")
     * @Soap\Result(phpType = "SoundView\Bundle\SaleBundle\Entity\SaleSoap")
     * @AclAncestor("svwd_sale_view")
     */
    public function getAction($id)
    {
        return $this->handleGetRequest($id);
    }

    /**
     * @Soap\Method("createSale")
     * @Soap\Param("task", phpType = "SoundView\Bundle\SaleBundle\Entity\SaleSoap")
     * @Soap\Result(phpType = "int")
     * @AclAncestor("svwd_sale_create")
     */
    public function createAction($sale)
    {
        return $this->handleCreateRequest();
    }

    /**
     * @Soap\Method("updateSale")
     * @Soap\Param("id", phpType = "int")
     * @Soap\Param("task", phpType = "SoundView\Bundle\SaleBundle\Entity\SaleSoap")
     * @Soap\Result(phpType = "boolean")
     * @AclAncestor("svwd_sale_update")
     */
    public function updateAction($id, $sale)
    {
        return $this->handleUpdateRequest($id);
    }

    /**
     * @Soap\Method("deleteSale")
     * @Soap\Param("id", phpType = "int")
     * @Soap\Result(phpType = "boolean")
     * @AclAncestor("svwd_sale_delete")
     */
    public function deleteAction($id)
    {
        return $this->handleDeleteRequest($id);
    }

    /**
     * @return ApiEntityManager
     */
    public function getManager()
    {
        return $this->container->get('svwd_sale.sale.manager.api');
    }

    /**
     * @return FormInterface
     */
    public function getForm()
    {
        return $this->container->get('svwd_sale.sale.form.api');
    }

    /**
     * @return ApiFormHandler
     */
    public function getFormHandler()
    {
        return $this->container->get('svwd_sale.sale.form.handler.api');
    }

    /**
     * {@inheritDoc}
     */
    protected function fixFormData(array &$data, $entity)
    {
        parent::fixFormData($data, $entity);

        unset($data['id']);
        unset($data['createdAt']);
        unset($data['updatedAt']);

        return true;
    }
}
