<?php

namespace SoundView\Bundle\PasswordListBundle\Migrations\Schema;

use Doctrine\DBAL\Schema\Schema;
use Oro\Bundle\MigrationBundle\Migration\Installation;
use Oro\Bundle\MigrationBundle\Migration\QueryBag;

/**
 * @SuppressWarnings(PHPMD.TooManyMethods)
 * @SuppressWarnings(PHPMD.ExcessiveClassLength)
 */
class SoundViewPasswordListBundleInstaller implements Installation
{
    /**
     * {@inheritdoc}
     */
    public function getMigrationVersion()
    {
        return 'v1_0';
    }

    /**
     * {@inheritdoc}
     */
    public function up(Schema $schema, QueryBag $queries)
    {
        /** Tables generation **/
        $this->createSvwdPasswordListTable($schema);

        /** Foreign keys generation **/
        $this->addSvwdPasswordListForeignKeys($schema);
    }

    /**
     * Create svwd_password_list table
     *
     * @param Schema $schema
     */
    protected function createSvwdPasswordListTable(Schema $schema)
    {
        $table = $schema->createTable('svwd_password_list');
        $table->addColumn('id', 'integer', ['autoincrement' => true]);
        $table->addColumn('organization_id', 'integer', ['notnull' => false]);
        $table->addColumn('owner_id', 'integer', ['notnull' => false]);
        $table->addColumn('domain', 'string', ['notnull' => false, 'length' => 255]);
        $table->addColumn('user', 'string', ['notnull' => false, 'length' => 100]);
        $table->addColumn('password', 'string', ['notnull' => false, 'length' => 100]);
        $table->addColumn('public', 'boolean', ['default' => '0']);
        $table->addColumn('createdAt', 'datetime', []);
        $table->addColumn('updatedAt', 'datetime', []);
        $table->addColumn('is_active', 'boolean', ['default' => '1']);
        $table->addColumn('old_password', 'string', ['notnull' => false, 'length' => 100]);
        $table->setPrimaryKey(['id']);
        $table->addIndex(['organization_id'], 'IDX_C5DE524A32C8A3DE', []);
        $table->addIndex(['owner_id'], 'IDX_C5DE524A7E3C61F9', []);
    }

    /**
     * Add svwd_password_list foreign keys.
     *
     * @param Schema $schema
     */
    protected function addSvwdPasswordListForeignKeys(Schema $schema)
    {
        $table = $schema->getTable('svwd_password_list');
        $table->addForeignKeyConstraint(
            $schema->getTable('oro_organization'),
            ['organization_id'],
            ['id'],
            ['onDelete' => 'SET NULL', 'onUpdate' => null]
        );
        $table->addForeignKeyConstraint(
            $schema->getTable('oro_user'),
            ['owner_id'],
            ['id'],
            ['onDelete' => 'SET NULL', 'onUpdate' => null]
        );
    }
}
