<?php
/**
 * Created by PhpStorm.
 * User: brandon
 * Date: 1/7/15
 * Time: 10:28 AM
 */

namespace SoundView\Bundle\PasswordListBundle\Form\Handler;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;

use Doctrine\Common\Persistence\ObjectManager;

use SoundView\Bundle\PasswordListBundle\Entity\Password;

class PasswordHandler
{
	/** @var FormInterface */
	protected $form;

	/** @var Request */
	protected $request;

	/** @var ObjectManager */
	protected $manager;

	/**
	 * @param FormInterface       $form
	 * @param Request             $request
	 * @param ObjectManager       $manager
	 */
	public function __construct(
		FormInterface $form,
		Request $request,
		ObjectManager $manager
	) {
		$this->form                = $form;
		$this->request             = $request;
		$this->manager             = $manager;
	}

	/**
	 * Process form
	 *
	 * @param  Password $entity
	 *
	 * @return bool  True on successful processing, false otherwise
	 */
	public function process(Password $entity)
	{
		$this->form->setData($entity);

		if (in_array($this->request->getMethod(), array('POST', 'PUT'))) {
			$this->form->submit($this->request);

			if ($this->form->isValid()) {
				$this->onSuccess($entity);

				return true;
			}
		}

		return false;
	}

	/**
	 * "Success" form handler
	 *
	 * @param Password $entity
	 */
	protected function onSuccess(Password $entity)
	{
		$this->manager->persist($entity);
		$this->manager->flush();
	}

	/**
	 * Get form, that build into handler, via handler service
	 *
	 * @return FormInterface
	 */
	public function getForm()
	{
		return $this->form;
	}
}
