<?php

namespace SoundView\Bundle\CommissionBundle\QueryDesigner;

use Oro\Bundle\QueryDesignerBundle\QueryDesigner\FunctionInterface;
use Oro\Bundle\QueryDesignerBundle\QueryDesigner\AbstractQueryConverter;

class CommissionTotalFunction implements FunctionInterface
{
    /**
     * {@inheritdoc}
     */
    public function getExpression($tableAlias, $fieldName, $columnName, $columnAlias, AbstractQueryConverter $qc)
    {
        // Make sure status table joined
        $opportunityStatusTableAlias = $qc->ensureChildTableJoined($tableAlias, 'status', 'left');

        return sprintf(
            "SUM(CASE WHEN (%s.name='won') THEN %s ELSE 0 END)",
            $opportunityStatusTableAlias,
            $columnName
        );
    }
}
