<?php

namespace SoundView\Bundle\CommissionBundle\Provider;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use SoundView\Bundle\SaleBundle\Entity\Sale;
use Soundview\Bundle\CommissionBundle\Entity\Commission;

class CommissionCalculator {
	
	
	protected $sale;
	
	protected $fee;
	
	protected $product = 0;
	
	protected $productSell = 0;
	protected $productCost = 0;
	protected $productReal = NULL;
	protected $productProfit = 0;
	
	protected $install = 0;
	
	protected $installSell = 0;
	protected $installCost = 0;
	protected $installReal = NULL;
	protected $installProfit = 0;
        
        protected $commissionAmount = 0;
        
        protected $totalProfit = 0;
	
	protected $totals;
	
	public function __construct()
    {
		
		
    }
	
	public function process()
	{
		
	}
	
	public function setFee()
	{
		
		
			if ($this->sale->getPaymentMethod() && $this->sale->getPaymentMethod()->getFee() > 0)
				{
			
				$fee = $this->sale->getPaymentMethod()->getFee();
				$fee = ($fee / 100) +1;
				$fee = 100 / ($fee * 100);
				
				$this->fee = $fee;
				
				
			} else {
		
		 	$this->fee = NULL;
		 
		}
	}
	
	public function calComm()
	{
		$this->productSell = $this->sale->getProductAmount();
		
		return $this;
	}
	
	public function initCalc()
	{
		
		$this->productCost = $this->sale->getProductCostTotal();
		
		
		if($this->fee){
			$this->productSell = $this->product * $this->fee;	
			$this->productReal = $this->product;
			$this->installSell = $this->install * $this->fee;	
			$this->installReal = $this->install;
		} else {
			$this->productSell = $this->product;
			$this->installSell = $this->install;
		}
		
		if($this->installSell > 0)
		{
			$this->installCost = $this->installSell * 0.7;	
		}
		
		$this->productProfit = $this->productSell - $this->productCost;
		$this->installProfit = $this->installSell - $this->installCost;
                
                $this->totalProfit = $this->productProfit + $this->installProfit;
                $this->setCommissionAmount();

		
	}
        
        public function setCommissionAmount()
        {
            if($this->totalProfit > 0){
                $this->commissionAmount = ($this->totalProfit * 0.31) / 2;
            }
        }
        public function getCommissionAmount()
        {
            return $this->commissionAmount;
        }
	
	
	public function getProductSell()
	{
		return $this->productSell;
	}
	
	public function getProductReal()
	{
		return $this->productReal;
	}
	public function getProductCost()
	{
		return $this->productCost;	
	}
	
	public function getInstallSell()
	{
		return $this->installSell;
	}
	
	public function getInstallReal()
	{
		return $this->installReal;
	}
	public function getInstallCost()
	{
		return $this->installCost;	
	}
	public function getProductProfit()
	{
		return $this->productProfit;	
	}
	public function getInstallProfit()
	{
		return $this->installProfit;	
	}
	
	public function getProductMargin()
	{
		if($this->getProductProfit() > 0){
			return ($this->getProductProfit() / $this->getProductSell());
		} else {
			return NULL;
		}
	}
        
	
	public function getInstallMargin()
	{
		if($this->installProfit > 0){
			return ($this->installProfit / $this->installSell);
		} else {
			return NULL;
		}
	}
	
	public function getTotals()
	{
		$sell = $this->productSell + $this->installSell;
		$real = $this->fee ? ($this->productReal + $this->installReal) : NULL;
		$cost = $this->productCost + $this->installCost;
		$profit = $this->productProfit + $this->installProfit;
		
		$margin = $profit > 0 ? $profit / $sell : NULL;
		
		
		return array(
			'sell' => $sell,
			'real' => $real,
			'cost' => $cost,
			'profit' => $profit,
			'margin' => $margin
		);
			
	}
	

	
	public function setSale(Sale $sale)
	{
		
		$this->sale = $sale;
		
		$this->product = $sale->getProductAmount();
		$this->install = $sale->getLaborAmount();
		$this->setFee();
		$this->initCalc();

		return $this;
		
	}
	
	

	
	
	public function calculate(Sale $sale)
	{
		$fee = $this->getFee($sale);
		
		if($sale->getSaleAmount() > 0)
		{
			
			$product = $this->calculateSell($fee, $sale->getSaleAmount(), $sale->getSaleCost());
			$product = array_merge($product, $this->calculateProfit($product['sell'], $product['cost']));
		
		} else {

			$product = array(
				'sell' => 0,
				'real' => NULL,
				'cost' => 0,
				'profit' => 0,
				'margin' => 0
			);
			
		}
		
		
		
			if($sale->getLaborAmount() > 0) {
				$install = $this->calculateSell($fee, $sale->getLaborAmount());
				$install = array_merge($install, $this->calculateProfit($install['sell']));
			} else { 
			$install = array(
				'sell' => 0,
				'real' => NULL,
				'cost' => 0,
				'profit' => 0,
				'margin' => 0
			);
		}
		
		$total = $this->calculateTotal($product, $install);
		
		$commissions = $this->calculateCommissions($total['profit']);
		
		$return = array(
			'product' => $product,
			'install' => $install,
			'total' => $total,
			'commission' => $commissions
		);
		
		return $return;
		
		
		
	}


	public function calculateCommission(Sale $sale)
	{
		
		//$em = $this->getDoctrine()->getManager();
        /** @var CalendarRepository $repo */
        //$repo     = $em->getRepository('SoundViewSaleBundle:Sale');
        //$sale = $repo->findOneBy(array('id' => $saleId));
		
		
		$calc = $this->calculate($sale);
		$commission = $calc['commission'];
		
		return $commission;
	}
	
	public function calculateCommissions($total)
	{
		if($total !== 0) {
			return ($total * 0.31) / 2;
		} else {
			return 0;
		}
			
	}

	public function calculateProfits(Sale $sale)
	{
		$prodSell = $sale->getSaleAmount();
		$installSell = $sale->getLaborAmount();
		
		$actualProdSell = NULL;
		$actualInstallSell = NULL;
		$realTotal = NULL;
		
		$fee = $sale->getPaymentMethod()->getFee();
		
		if($fee !== 0)
		{
			$fee = ($fee / 100) + 1;
			$fee = 100 / ($fee * 100);
			
			
			$actualProdSell = $prodSell;
			$prodSell = $prodSell * $fee;
			
			$actualInstallSell = $installSell;
			$installSell = $installSell * $fee;	
			
			$realTotal = $actualInstallSell + $actualProdSell;
		}
		
		$feeData = array(
			'percent' => $sale->getPaymentMethod()->getFee()
		);
		
		$prodProfit = $prodSell - $sale->getSaleCostTotal();
		$installCost = $installSell * 0.7;
		$installProfit = $installSell - $installCost;
		
		$totalSell = $installSell + $prodSell;
		$totalCost = $installCost + $sale->getSaleCostTotal();
		
		$totalProfit = $totalSell - $totalCost;
		$totalMargin = $totalProfit / $totalSell;
		
		$productData = array(
			'profit' => $prodProfit,
			'margin' => $prodProfit / $prodSell,
			'sell' => $prodSell,
			'realSell' => $actualProdSell
		);
		
		$installData = array(
			'cost' => $installCost,
			'profit' => $installProfit,
			'sell' => $installSell,
			'realSell' => $actualInstallSell,
			'margin' => $installProfit / $installSell
		);
		
		$totalData = array(
			'sell' => $totalSell,
			'realSell' => $realTotal,
			'cost' => $totalCost,
			'profit' => $totalProfit,
			'margin' => $totalMargin
		);
		
		$response = array(
			'product' => $productData,
			'install' => $installData,
			'total' => $totalData,
			'fee' => $feeData
		);
		
		return $response;		
	}
	
	
	
	public function calculateSell($fee, $sell, $cost = NULL)
	{
		$return = array('real' => NULL, 'sell' => $sell, 'cost' => $cost);
		
		if(isset($fee))
			{	
				$return['real'] = $sell;
				$return['sell'] = $sell * $fee;
				
			}	
			
			return $return;
	}
	
	
	
	public function calculateProfit($sell, $cost = NULL)
	{
		
		if(isset($cost)) {
				$profit = $sell - $cost;
				$margin = $profit / $sell;
			} else {
				$cost = $sell * 0.7;
				$profit = $sell - $cost;
				$margin = $profit / $sell;
			}
			
			
			
			return array('profit' => $profit, 'margin' => $margin, 'cost' => $cost );
			
	}
	
	public function calculateTotal($product, $install)
	{
		$total = array();
		$total['profit'] = $product['profit'] + $install['profit'];
		$total['margin'] = $product['margin'] + $install['margin'];
		$total['cost'] =  $product['cost'] + $install['cost'];
		$total['sell'] = $product['sell'] + $install['sell'];
		$total['real'] = $product['real'] + $install['real'];
		
		return $total;
	}

}