<?php

namespace SoundView\Bundle\CommissionBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;
use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\TagBundle\Entity\Taggable;
use Oro\Bundle\OrganizationBundle\Entity\Organization;

use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;

use SoundView\Bundle\CommissionBundle\Provider\CommissionCalculator;

use SoundView\Bundle\CommissionBundle\Entity\CommissionType;
use SoundView\Bundle\CommissionBundle\Entity\CommissionStatus;
use SoundView\Bundle\SaleBundle\Entity\Sale;



 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_sale_commission",
 *      indexes={@ORM\Index(name="svwd_sale_commission_idx",columns={"ref_number"})}
 * )
 * @ORM\HasLifecycleCallbacks()
 * @UniqueEntity(
 *     fields="refNumber",
 *     message="Ref number exists"
 * )
 * @Oro\Loggable
 * @Config(
 *      routeName="svwd_sale_commission_index",
 *      routeView="svwd_sale_commission_view",
 *      defaultValues={
 *          "entity"={
 *              "icon"="icon-list-alt"
 *          },
 *          "ownership"={
 *              "owner_type"="USER",
 *              "owner_field_name"="owner",
 *              "owner_column_name"="owner_id",
 *              "organization_field_name"="organization",
 *              "organization_column_name"="organization_id"
 *          },
 *          "security"={
 *              "type"="ACL",
 *              "group_name"=""
 *          },
 *          "dataaudit"={
 *              "auditable"=true
 *          }
 *      }
 * )
 */
 
 
 
class Commission
{
    
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="ref_number", type="string", length=255, nullable=true, unique=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $refNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     */
    protected $description;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_due", type="datetime", nullable=true)
     */
    protected $dueDate;
    

    /**
     * @var SaleType
     *
     * @ORM\ManyToOne(targetEntity="CommissionType")
     * @ORM\JoinColumn(name="type", referencedColumnName="name", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $type;
    
    /**
     * @var SaleStatus
     *
     * @ORM\ManyToOne(targetEntity="CommissionStatus")
     * @ORM\JoinColumn(name="status", referencedColumnName="name", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $status;
    
    /**
     * @var Collection
     *
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\SaleBundle\Entity\Sale", inversedBy="commissions")
     * @ORM\JoinColumn(name="sale_id", referencedColumnName="id", onDelete="CASCADE")
     * @ORM\OrderBy({"createdAt" = "DESC"})
     * @Oro\Versioned
     * @Soap\ComplexType("SoundView\Bundle\SaleBundle\Entity\Commission[]", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          },
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *      }
     * )
     */
    protected $sale;


    /**
     * @var double
     *
     * @ORM\Column(name="amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $amount;
    
     

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="owner_id", referencedColumnName="id", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $owner;

        /**
     * @var Organization
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\OrganizationBundle\Entity\Organization")
     * @ORM\JoinColumn(name="organization_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "dataaudit"={
     *              "auditable"=true
     *          },
     *          "importexport"={
     *              "order"=190,
     *              "short"=true
     *          }
     *      }
     * )
     */
    protected $organization;

    /**
     * @var Account
     *
     * @ORM\ManyToOne(targetEntity="OroCRM\Bundle\AccountBundle\Entity\Account")
     * @ORM\JoinColumn(name="related_account_id", referencedColumnName="id", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $relatedAccount;
	
	
	
	/**
     * @var bool
     *
     * @ORM\Column(name="is_due", type="boolean")
     */
	protected $due = 0;
	
	/**
     * @var bool
     *
     * @ORM\Column(name="is_paid", type="boolean")
     */
	protected $paid = 0;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_paid", type="datetime", nullable=true)
     */
    protected $paidDate;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="created_by_user_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "excluded"=true
     *          }
     *      }
     * )
     */
    protected $createdBy;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="updated_by_user_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "excluded"=true
     *          }
     *      }
     * )
     */
    protected $updatedBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "entity"={
     *              "label"="oro.ui.created_at"
     *          }
     *  }
     * )
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "entity"={
     *              "label"="oro.ui.updated_at"
     *          }
     *  }
     * )
     */
    protected $updatedAt;



    
    public function __construct()
    {
        

    }
    
    
        /**
     * Get entity class name.
     * TODO: Remove this temporary solution for get 'view' route in twig after EntityConfigBundle is finished
     * @return string
     */
//    public function getClass()
//    {
//        return 'SoundView\Bundle\SaleBundle\Entity\Sale';
//    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }
	


    /**
     * Set orderNumber
     *
     * @param string $orderNumber
     * @return SalesOrder
     */
    public function setRefNumber($refNumber)
    {
        $this->refNumber = $refNumber;

        return $this;
    }

    /**
     * Get orderNumber
     *
     * @return string 
     */
    public function getRefNumber()
    {
        return $this->refNumber;
    }
    
    
    
    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * @return bool
     */
    public function isDueDateExpired()
    {
        return $this->getDueDate() &&  $this->getDueDate() < new \DateTime();
    }

    /**
     * @param \DateTime $dueDate
     */
    public function setDueDate(\DateTime $dueDate = null)
    {
        $this->dueDate = $dueDate;
    }
    
     /**
     * @param float $laborAmount
     *
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    

    /**
     * @return User
     */
    public function getOwner()
    {
        return $this->owner;
    }

    /**
     * @return mixed|null
     */
    public function getOwnerId()
    {
        return $this->getOwner() ? $this->getOwner()->getId() : null;
    }

    /**
     * @param User $owner
     */
    public function setOwner($owner = null)
    {
        $this->owner = $owner;
    }

        /**
     * @return User
     */
    public function getSale()
    {
        return $this->sale;
    }

    /**
     * @return mixed|null
     */
    public function getSaleId()
    {
        return $this->getSale() ? $this->getSale()->getId() : null;
    }

    /**
     * @param User $owner
     */
    public function setSale($sale = null)
    {
        $this->sale = $sale;
    }

    /**
     * @return Account
     */
    public function getRelatedAccount()
    {
        return $this->relatedAccount;
    }

    /**
     * @return mixed|null
     */
    public function getRelatedAccountId()
    {
        return $this->getRelatedAccount() ? $this->getRelatedAccount()->getId() : null;
    }

    /**
     * @param Account $account
     */
    public function setRelatedAccount($account = null)
    {
        $this->relatedAccount = $account;
    }

        /**
     * @return CommissionType
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param CommissionType $commissionType
     */
    public function setType(CommissionType $type)
    {
        $this->type = $type;
    }


	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isDue()
    {
        return $this->isPaid() ? false : $this->due;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setDue($due)
    {
        $this->due = $due;

        return $this;
    }
	
	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isPaid()
    {
        return $this->paid;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setPaid($paid)
    {
        $this->paid = $paid;

        return $this;
    }
	
	public function isFirstHalf()
	{	
		return $this->type->getName() == 'first' ? true : false;	
	}
	
	public function isSecondHalf()
	{	
		return $this->type->getName() == 'second' ? true : false;	
	}


        /**
     * @return \DateTime
     */
    public function getPaidDate()
    {
        return $this->paidDate;
    }


    /**
     * @param \DateTime $dueDate
     */
    public function setPaidDate(\DateTime $paidDate = null)
    {
        $this->paidDate = $paidDate;
    }



    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param CommissionStatus $status
     */
    public function setStatus(CommissionStatus $status)
    {
        $this->status = $status;
    }
	

    /**
     * @return Status
     */
    public function getStatus()
    {
        return $this->status;
    }
    

    /**
     * @param \Oro\Bundle\UserBundle\Entity\User $createdBy
     *
     * @return Contact
     */
    public function setCreatedBy($createdBy)
    {
        $this->createdBy = $createdBy;

        return $this;
    }

    /**
     * @return \Oro\Bundle\UserBundle\Entity\User
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }

    /**
     * @param \Oro\Bundle\UserBundle\Entity\User $updatedBy
     *
     * @return Contact
     */
    public function setUpdatedBy($updatedBy)
    {
        $this->updatedBy = $updatedBy;

        return $this;
    }

    /**
     * @return \Oro\Bundle\UserBundle\Entity\User
     */
    public function getUpdatedBy()
    {
        return $this->updatedBy;
    }
	
    public function getCommission()
    {
        $calculator = new CommissionCalculator();
        
        $calculator->setSale($this->getSale());
        
        //$commissionAmount = $calculator->getCommissionAmount();
        
        return $calculator;
    }
    
        /**
     * @return string
     */
    public function __toString()
    {
        $name = $this->getRefNumber();
        $name = preg_replace('/ +/', ' ', $name);

        return (string) trim($name);
    }
	
    public function createRefNumber()
    {
        $result = 'CMN-';

        $rep = substr($this->getOwner()->getFirstName(), 0, 1);
        $rep .= substr($this->getOwner()->getLastName(), 0, 3);
        $result .= strtoupper($rep);
        $result .= $this->getSale()->getSoNumber();

        if($this->isFirstHalf()){
                $result .= 'A';
        } elseif($this->isSecondHalf()){
                $result .= 'B';
        }
        elseif($this->type->getName() == 'adjustment') {
                $result .= strtoupper(chr(($this->getSale()->getCommissions()->count() % 26) + 97));
                $result .= '-ADJ';
        }

        $result = preg_replace('/ +/', ' ', $result);

        $this->refNumber = (string) trim($result);	
    }
    
        /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }

            /**
     * Set organization
     *
     * @param Organization $organization
     * @return Sale
     */
    public function setOrganization(Organization $organization = null)
    {
        $this->organization = $organization;

        return $this;
    }

    /**
     * Get organization
     *
     * @return Organization
     */
    public function getOrganization()
    {
        return $this->organization;
    }
}
